do_neutral_local_comm <- function(J_M, nu, J, m)
  {
  SAD_M = do_neutral_metacomm(J_M,nu)$abunds
  S_M = length(SAD_M)

  M = rep(0,J)

  Ss = c(1)

  while ( sum(M==0) > 0 )
    {
    death_ids = sample(J,J,replace=T)
    birth_ids = sample(J,J,replace=T)
    do_imm = (runif(J)<m)
    for ( i in 1:J )
      {
      if ( do_imm[i] )
        {
        M[death_ids[i]] = sample(S_M,1,prob=SAD_M)
        } else
        {
        M[death_ids[i]] = M[birth_ids[i]]
        }
      }
  
    Ss = c(Ss,length(unique(M)))
    }
  return(list(Ss=Ss,abunds=table(M)))
  }

J_M = 10000
nu = 0.001
J = 1000
m = 0.1
comm = do_neutral_local_comm(J_M,nu,J,m)

plot(comm$Ss,type='l')
theta = J_M*nu/(1-nu)
mu = J*m/(1-m)
S_eq = theta*log(1+(mu/theta)*log(1+J/mu))
abline(h=S_eq,lty=2) 
